#include <amxmodx>
#include <umitem>
#include <engine>

new PLUGIN_NAME[] 	= "UM Item: Climbing Gear"
new PLUGIN_AUTHOR[] 	= "Cheap_Suit"
new PLUGIN_VERSION[] 	= "1.1"

new bool:ftimeover
new bool:g_ClimbingGear[33]
public plugin_init() 
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)
	register_item("Climbing Gear", "Climb walls (hold jump & hold forward or back)", 1000)
	register_logevent("LogEvent_RoundStart", 2, "0=World triggered", "1=Round_Start")
	register_event("TextMsg", "Event_GameRestart", "a", "2=#Game_will_restart_in") 
	register_event("SendAudio", "Event_RoundEnd", "a", "2=%!MRAD_terwin", "2=%!MRAD_ctwin", "2=%!MRAD_rounddraw")
}

public client_connect(id) {
	g_ClimbingGear[id] = false
}

public Event_RoundEnd() {
	ftimeover = false
}
	
public Event_GameRestart()
{
	new Float:fRestartCvar = get_cvar_float("sv_restart")
	set_task((fRestartCvar - 0.5), "Event_RoundEnd")	
}

public LogEvent_RoundStart(id) {
	ftimeover = true
}

public Enable_Item(id) {
	g_ClimbingGear[id] = true
}

public Disable_Item(id) {
	g_ClimbingGear[id] = false
}

public client_PreThink(id)
{
	if(!is_user_connected(id) || !is_user_alive(id)) {
		return PLUGIN_CONTINUE
	}
	
	if(!ftimeover || !g_ClimbingGear[id]) {
		return PLUGIN_CONTINUE
	}
	
	new Float: fVelocity[3]
	entity_get_vector(id, EV_VEC_velocity, fVelocity)
		
	new Buttons = get_user_button(id)
	if(Buttons & IN_JUMP && (Buttons & IN_FORWARD || Buttons & IN_BACK)) 
	{
		if(fVelocity[0] == 0.0 || fVelocity[1] == 0.0)
		{
			fVelocity[1] = 10.0
			fVelocity[2] = 220.0
			entity_set_vector(id, EV_VEC_velocity, fVelocity)
		}
	}
	return PLUGIN_CONTINUE
}
